﻿using System.Linq;
using System.Net;
using System.Net.Http.Headers;
using System.Web.Http;

using VIRP.EFR.BLL;

namespace VIRP_WEB.Api.EFR
{
    [Authorize]
    public class PatientImagingController : ApiController
    {
        private const string ContextHeader = "__Registry_Context__";
        private const string IdentifierHeader = "__Registry_Identifier__";
        private const string ClearCacheHeader = "__Clear_Cache__";

        private readonly PatientImagingManager ImagingManager;

        public PatientImagingController()
        {
            ImagingManager = new PatientImagingManager();
        }

        [AjaxOnly]
        [HttpGet]
        [Route("EFR/API/Token")]
        public SimpleResponse<string> GetApiToken()
        {
            var headerValues = GetHeaderValues();
            if (AnyInvalidHeaders(headerValues))
                return new SimpleResponse<string>(HttpStatusCode.BadRequest);

            var token = ImagingManager.GetApiToken(
                headerValues.Context, 
                int.Parse(headerValues.Identifier),
                headerValues.ClearCache);

            return new SimpleResponse<string>(token, HttpStatusCode.OK);
        }

        private bool AnyInvalidHeaders(TokenRequestHeader headerValues)
        {
            int id;

            return (headerValues == null
                || string.IsNullOrEmpty(headerValues.Context)
                || string.IsNullOrEmpty(headerValues.Identifier)
                || !int.TryParse(headerValues.Identifier, out id));
        }

        private TokenRequestHeader GetHeaderValues()
        {
            var headers = Request.Headers;
            var context = GetStringHeaderValue(headers, ContextHeader);
            var id = GetStringHeaderValue(headers, IdentifierHeader);
            var clearCache = GetBoolHeaderValue(headers, ClearCacheHeader);

            return new TokenRequestHeader
            {
                Context = context,
                Identifier = id,
                ClearCache = clearCache
            };
        }

        private string GetStringHeaderValue(HttpRequestHeaders headers, string key)
        {
            var tryGetHeader = headers
                .SingleOrDefault(h => h.Key.Equals(key, System.StringComparison.OrdinalIgnoreCase))
                .Value;

            return tryGetHeader != null ? tryGetHeader.SingleOrDefault() : null;
        }

        private bool? GetBoolHeaderValue(HttpRequestHeaders headers, string key)
        {
            var tryGetHeaderValue = GetStringHeaderValue(headers, key);

            bool result;

            if (bool.TryParse(tryGetHeaderValue, out result))
                return result;

            return null;
        }
    }
}